/*
 * SHT40.c
 *
 *  Created on: 30 Oct 2024
 *      Author: nx827554
 *
*/
#include "SHT40.h"

/**
* @brief  fetch humidity and temperature data from SHT40 chip
* @param  float*t_degC pointer for Temperature
* @param  float*rh_pRH pointer for Humidity
* @return HAL_StatusTypeDef code status
*/
HAL_StatusTypeDef readHumidity (float*t_degC, float*rh_pRH){

	uint8_t txbuf[10];// bytes to send
	uint8_t rx_bytes[10];// bytes to receive
	HAL_StatusTypeDef status;

	txbuf[0]=0xFD;//address of SHT40 chip on I2C bus
	status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_HUMIDITY_ADDRESS, txbuf, (uint16_t) 1, 1000);// write to SHT40 to provoke transmission
	if(status!=HAL_OK)
	{
	  printf("SHT40: I2C transmit error %d\r\n", status);
	}
	else
	{

	  HAL_Delay(10);	//Wait before sending read 0.01 sec

	  status=HAL_I2C_Master_Receive(&hi2c2, (uint16_t) EXT_HUMIDITY_ADDRESS, rx_bytes, (uint16_t) 6, 1000);// Read result from SHT40 Chip/receive result
	  if(status!=HAL_OK)
	  {
		  printf("SHT40: I2C receive error %d\r\n", status);
	  }
	  else
	  {
		  float t_ticks = (float) (rx_bytes[0] * 256 + rx_bytes[1]);// convert bytes to usable numbers
		  float rh_ticks = (float) (rx_bytes[3] * 256 + rx_bytes[4]);

		  *t_degC = (float) (-45.0 + 175.0 * (t_ticks)/65535.0);// converting to celsius and % units
		  *rh_pRH = (float) (-6.0 + 125.0* (rh_ticks)/65535.0);

		  if (*rh_pRH > 100.0) *rh_pRH = (float)100.0;//ensuring humidity is within boundaries
		  if (*rh_pRH < 0.0) *rh_pRH = (float)0.0;
	  }
	}
	return status;
}
